package myphotos

class TopicController {
    
    def index() {

    }

    def view() {
        def topic = Topic.get(params.id)
        def model = [topic: topic, photos: topic.photos]

        render(view: "view", model: model)
    }

    def upload() {
        def topic = Topic.get(params.id)
        def model = [topic: topic]

        render(view: "upload", model: model)
    }

    def confirmUpload() {
        def topic = Topic.get(params.id)

        List fileList = request.getFiles("photos")
        fileList.each { file ->
            def photo = new Photo(data: file.getBytes())
            topic.addToPhotos(photo)
        }
        topic.save(flush: true)

        return redirect(controller: "topic", action: "view", params: [id: topic.id])
    }

    def edit() {
        def topic = Topic.get(params.id)
        def model = [topic: topic]

        render(view: "edit", model: model)
    }

    def confirmEdit() {
        def topic = Topic.get(params.id)
        topic.name = params.topicName
        topic.save(flush: true)
        return redirect(controller: "topic", action: "view", params: [id: topic.id])
    }

    def delete() {
        Topic.get(params.id).delete(flush: true)
        return redirect(uri: "/")
    }
}
